<?php
// Add custom Theme Functions here
// hide update notifications
function remove_core_updates(){
global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}
//add_filter('pre_site_transient_update_core','remove_core_updates'); //hide updates for WordPress itself
//add_filter('pre_site_transient_update_plugins','remove_core_updates'); //hide updates for all plugins
add_filter('pre_site_transient_update_themes','remove_core_updates'); //hide updates for all themes

add_action('admin_head', 'my_custom_css');
function my_custom_css() {
  echo '<style>#wp-admin-bar-flatsome-activate{display:none!important;}</style>';
}

/* Tao code chen kk star rating cho ladipage */
function wpc_elementor_shortcode( $atts ) {
    echo kk_star_ratings();
}
add_shortcode( 'elementor_kk_star_ratings', 'wpc_elementor_shortcode');

/* excerpt length */
add_filter( 'excerpt_length', 'smile_prefix_excerpt_length' );
function smile_prefix_excerpt_length() {
return 18;
}

/* posted on */
function flatsome_posted_on() {
    $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
    if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
        $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
    }
 
    $time_string = sprintf( $time_string,
        esc_attr( get_the_date( 'c' ) ),
        esc_html( get_the_date() ),
        esc_attr( get_the_modified_date( 'c' ) ),
        esc_html( get_the_modified_date() )
    );
 
    $posted_on = sprintf(
        esc_html_x( '%s', 'post date', 'flatsome' ),
        '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
    );
 
    $byline = sprintf(
        esc_html_x( '%s', 'post author', 'flatsome' ),
        '<span class="meta-author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
    );
    echo '<span class="posted-on"><i class="icon-clock"></i>' . $posted_on . '</span><span class="byline"><i class="icon-user"></i> ' . $byline . '</span>';
 
}


/*
 * Code bài viết liên quan theo chuyên mục
*/
function related_cat() {
    $output = '';
    if (is_single()) {
      global $post;
      $categories = get_the_category($post->ID);
      if ($categories) {
        $category_ids = array();
        foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;
        $args=array(
          'category__in' => $category_ids,
          'post__not_in' => array($post->ID),
          'posts_per_page'=>6,
          'ignore_sticky_posts'=>1
        );
        
        $my_query = new wp_query( $args );
        if( $my_query->have_posts() ):
            $output .= '<div class="container"><div class="related-box">';
                $output .= '<span class="related-head">Bài viết liên quan</span><div class="row related-post">';
                    while ($my_query->have_posts()):$my_query->the_post();
                    $output .= 
                        '<div class="col large-4"><div class="box-post">
                            <a href="'.get_the_permalink().'" title="'.get_the_title().'">
                                <div class="feature">
                                    <div class="image" style="background-image:url('. get_the_post_thumbnail_url() .');"></div>
                                </div>                     
                            </a>
                            <div class="related-title"><a href="'.get_the_permalink().'" title="'.get_the_title().'">'.get_the_title().'</a></div></div>
                        </div>';
                    endwhile;
                $output .= '</div>';
            $output .= '</div></div>';
        endif;   //End if.
      wp_reset_query();
    }
    return $output;
  }
}
add_shortcode('related_cat','related_cat');

/*
 * Code add Footer
*/
function add_this_script_footer(){
?>
	<style>#wp-admin-bar-flatsome-activate{display:none!important;}</style>
	<div id="bottom-conversion">
	<a href="tel:0909058535" aria-label="phone"><div class="phone"></div></a>
			<a href="https://zalo.me/0909058535" rel="nofollow" aria-label="zalo" target="_blank"><div class="zalo"></div></a>

	<a href="tel:0909181545" aria-label="phone"><div class="phone"></div></a>
	<a href="https://zalo.me/0909181545" rel="nofollow" aria-label="zalo" target="_blank"><div class="zalo"></div></a>
	</div>
<?php
}
add_action('wp_footer', 'add_this_script_footer');
